SuperStrict

' Example 4: Voice Management
' Demonstrates: GetVoiceCount(), GetVoiceName(), SetSpeechVoice(), SetSpeechVoiceByName()


Framework BRL.StandardIO

Import "-L."
Import "-lBlitzSpeech"
Include "BlitzSpeechH.bmx"

Print "BlitzSpeech - Voice Management Example"
Print ""

If InitSpeech() = SP_INIT_SUCCESS Then
    
    ' List all available voices
    Local count:Int = GetVoiceCount()
    Print "Found " + count + " voices installed:"
    Print ""
    
    For Local i:Int = 0 Until count
        Local name:String = String.FromCString(GetVoiceName(i))
        Local lang:String = String.FromCString(GetVoiceLanguage(i))
        Local vtype:Int = GetVoiceType(i)
        
        Local typeStr:String = "OneCore"
        If vtype = SP_VOICE_TYPE_DESKTOP Then typeStr = "Desktop"
        
        Print "  [" + i + "] " + name
        Print "      Language: " + lang + " | Type: " + typeStr
    Next
    Print ""
    
    ' Get current voice
    Local currentVoice:Int = GetCurrentVoice()
    Print "Current voice index: " + currentVoice
    Print "Current voice name: " + String.FromCString(GetVoiceName(currentVoice))
    Print ""
    
    ' Switch between voices
    If count >= 2 Then
        Print "Switching between first two voices..."
        Print ""
        
        SetSpeechVoice(0)
        Print "Voice 0: " + String.FromCString(GetVoiceName(0))
        SpeakText("This is the first voice")
        Delay(1000)
        
        SetSpeechVoice(1)
        Print "Voice 1: " + String.FromCString(GetVoiceName(1))
        SpeakText("This is the second voice")
        Delay(1000)
        
        ' Reset to first voice
        SetSpeechVoice(0)
    Else
        Print "Only one voice available - can't demo switching"
    End If
    Print ""
    
    ' Try to set voice by name (partial match)
    Print "Trying to find a voice by name..."
    Local result:Int = SetSpeechVoiceByName("david")
    If result >= 0 Then
        Print "Found and set voice containing 'david' at index: " + result
        SpeakText("Voice selected by name")
    Else
        Print "No voice found with 'david' in the name"
    End If
    Print ""
    
    CleanupSpeech()
    Print "Done!"
Else
    Print "Failed to initialize speech!"
EndIf